/*
 * Decompiled with CFR 0.152.
 */
package com.jfoenix.transitions.template;

import java.util.function.BooleanSupplier;
import javafx.animation.Interpolator;
import javafx.beans.value.WritableValue;

public class ConditionalInterpolator
extends Interpolator {
    private final Interpolator interpolator;
    private final WritableValue<Object> target;
    private final BooleanSupplier condition;

    public ConditionalInterpolator(Interpolator interpolator, WritableValue<Object> target, BooleanSupplier condition) {
        this.interpolator = interpolator;
        this.target = target;
        this.condition = condition;
    }

    public Object interpolate(Object startValue, Object endValue, double fraction) {
        return this.condition.getAsBoolean() ? this.interpolator.interpolate(startValue, endValue, fraction) : this.target.getValue();
    }

    public boolean interpolate(boolean startValue, boolean endValue, double fraction) {
        return this.condition.getAsBoolean() ? this.interpolator.interpolate(startValue, endValue, fraction) : ((Boolean)this.target.getValue()).booleanValue();
    }

    public double interpolate(double startValue, double endValue, double fraction) {
        return this.condition.getAsBoolean() ? this.interpolator.interpolate(startValue, endValue, fraction) : ((Double)this.target.getValue()).doubleValue();
    }

    public int interpolate(int startValue, int endValue, double fraction) {
        return this.condition.getAsBoolean() ? this.interpolator.interpolate(startValue, endValue, fraction) : ((Integer)this.target.getValue()).intValue();
    }

    public long interpolate(long startValue, long endValue, double fraction) {
        return this.condition.getAsBoolean() ? this.interpolator.interpolate(startValue, endValue, fraction) : ((Long)this.target.getValue()).longValue();
    }

    protected double curve(double t) {
        return 0.0;
    }
}

